/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astrotime;

public class Editing
extends Astroformat {
    public String inf_string;
    public static final boolean DEBUG = false;
    private static char[] sexachar = new char[]{'\u0000', ' ', ':', 'h', 'm', 's', 'd', '\u00b0', '\'', '\"'};
    private static double[] fac6 = new double[]{12.0, 30.0, 24.0, 60.0, 60.0};
    private static short[] sexadrive = new short[]{0, 0, 4352, 8464, 4608, 8736, 5696, 9797, 5696, 9029, 0, 1536, 768, 1792, 6016, 10121};
    private static int[] datedrive = new int[]{418, 19, 673, 49, 421, 421, 1489, 1489, 107172, 107428, 316113, 304033, 185537, 238785, 184740, 250276};
    private static char[] datesep = new char[]{'-', ' ', ',', '/'};

    public Editing() {
        this.inf_string = "Inf";
    }

    public Editing(String string) {
        this.setNaN(string);
        this.inf_string = "Inf";
    }

    public void setInfinite(String string) {
        this.inf_string = string;
    }

    private static void edN(StringBuffer stringBuffer, long l, int n, int n2) {
        char c = '\u0000';
        String string = Long.toString(l);
        int n3 = n - string.length();
        if ((n2 & 0x80000010) != 0) {
            c = (n2 & Integer.MIN_VALUE) != 0 ? (char)'-' : '+';
            --n3;
        }
        if ((n2 & 0x20) != 0) {
            if (c != '\u0000') {
                stringBuffer.append(c);
            }
            while (n3 > 0) {
                stringBuffer.append('0');
                --n3;
            }
        } else {
            while (n3 > 0) {
                stringBuffer.append(' ');
                --n3;
            }
            if (c != '\u0000') {
                stringBuffer.append(c);
            }
        }
        stringBuffer.append(string);
    }

    private static boolean remove_zeroes(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n) == '0') {
            --n;
        }
        if (stringBuffer.charAt(n) == '.') {
            bl = true;
        } else {
            ++n;
        }
        stringBuffer.setLength(n);
        return bl;
    }

    public StringBuffer editFlags(StringBuffer stringBuffer, int n, String[] stringArray) {
        int n2 = n;
        boolean bl = false;
        for (int i = 0; n2 != 0 && i < stringArray.length; ++i, n2 >>>= 1) {
            if ((n2 & 1) == 0) continue;
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append(stringArray[i]);
        }
        if (n2 != 0) {
            stringBuffer.append("0x" + Integer.toHexString(n2 << stringArray.length) + "??");
        }
        return stringBuffer;
    }

    public StringBuffer editNaN(StringBuffer stringBuffer, int n) {
        for (int i = n - this.nulls[0].length(); i > 0; --i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.nulls[0]);
        return stringBuffer;
    }

    public StringBuffer editInfinite(StringBuffer stringBuffer, int n, int n2) {
        int n3 = n - this.inf_string.length();
        if (n2 != 0) {
            --n3;
        }
        while (--n3 >= 0) {
            stringBuffer.append(' ');
        }
        if (n2 < 0) {
            stringBuffer.append('-');
        } else if (n2 != 0) {
            stringBuffer.append('+');
        }
        stringBuffer.append(this.inf_string);
        return stringBuffer;
    }

    public StringBuffer editLong(StringBuffer stringBuffer, long l, int n, int n2) {
        int n3 = n2;
        long l2 = l;
        if (l2 == Long.MIN_VALUE) {
            this.editNaN(stringBuffer, n);
        } else {
            if (l2 < 0L) {
                n3 |= Integer.MIN_VALUE;
                l2 = -l2;
            }
            if (l2 == Long.MAX_VALUE) {
                this.editInfinite(stringBuffer, n, n3 & 0x80000010);
            } else {
                Editing.edN(stringBuffer, l2, n, n3);
            }
        }
        return stringBuffer;
    }

    public StringBuffer editInt(StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4 = n3;
        long l = n;
        if (n == Integer.MIN_VALUE) {
            this.editNaN(stringBuffer, n2);
        } else {
            if (n < 0) {
                n4 |= Integer.MIN_VALUE;
                l = -l;
            }
            if (l == Integer.MAX_VALUE) {
                this.editInfinite(stringBuffer, n2, n4 & 0x80000010);
            }
            Editing.edN(stringBuffer, l, n2, n4);
        }
        return stringBuffer;
    }

    public StringBuffer edit(StringBuffer stringBuffer, int n, int n2) {
        this.editInt(stringBuffer, n, n2, 0);
        return stringBuffer;
    }

    public StringBuffer editDecimal(StringBuffer stringBuffer, double d, int n, int n2, int n3) {
        boolean bl = n2 < -1;
        double d2 = d;
        int n4 = n3;
        if (bl) {
            n2 = -n2;
        }
        if (Double.isNaN(d)) {
            int n5 = n;
            if (n2 >= 0) {
                ++n5;
            }
            this.editNaN(stringBuffer, n5);
            return stringBuffer;
        }
        if (d < 0.0) {
            n4 |= Integer.MIN_VALUE;
            d2 = -d2;
        }
        if (Double.isInfinite(d2)) {
            int n6 = n;
            if (n2 >= 0) {
                ++n6;
            }
            this.editInfinite(stringBuffer, n6, n4 & 0x80000010);
            return stringBuffer;
        }
        if (d2 >= 1.0E19) {
            return this.editDouble(stringBuffer, d, 2, n + n2 - 3, n3);
        }
        if ((n3 & 0x80) != 0) {
            long l = (int)d;
            if (d < 0.0) {
                --l;
            }
            return this.editDate(stringBuffer, (int)l, n3);
        }
        if (sexadrive[n3 & 0xF] != 0) {
            return this.editSexa(stringBuffer, d, n, n2, n3);
        }
        if ((n3 & 0x40) == 0) {
            d2 = n2 <= 0 ? (d2 += 0.5) : (d2 += 0.5 / AstroMath.dexp(n2));
        }
        long l = (long)d2;
        if (n > 0 || l != 0L) {
            Editing.edN(stringBuffer, l, n, n4);
        }
        if (n2 >= 0) {
            stringBuffer.append('.');
        }
        if (n2 > 0) {
            d2 -= (double)l;
            l = (long)(d2 *= AstroMath.dexp(n2));
            Editing.edN(stringBuffer, l, n2, 32);
            if (bl && Editing.remove_zeroes(stringBuffer)) {
                stringBuffer.append(".0");
            }
        }
        return stringBuffer;
    }

    public StringBuffer editDouble(StringBuffer stringBuffer, double d, int n, int n2, int n3) {
        boolean bl;
        boolean bl2;
        String string = (n3 & 0xA) != 0 ? "x10" : "e";
        int n4 = n3;
        int n5 = stringBuffer.length();
        double d2 = d;
        boolean bl3 = bl2 = n <= 0;
        if (sexadrive[n3 & 0xF] != 0) {
            return this.editSexa(stringBuffer, d, n, n2, n3);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return this.editDecimal(stringBuffer, d, n + 2, string.length(), n3);
        }
        if (bl2) {
            n = 15;
        }
        if (d < 0.0) {
            n4 |= Integer.MIN_VALUE;
            d2 = -d2;
        }
        boolean bl4 = bl = (n3 & 1) == 0;
        if (bl && d2 != 0.0) {
            boolean bl5 = bl = d2 >= 0.1 && d2 < 1000.0;
        }
        if (bl) {
            int n6 = 2;
            if (d2 >= 10.0) {
                ++n6;
            }
            if (d2 >= 100.0) {
                ++n6;
            }
            this.editDecimal(stringBuffer, d, bl2 ? 1 : n6, n - n6 + 1, n3);
            if (bl2) {
                Editing.remove_zeroes(stringBuffer);
            } else {
                for (n6 = string.length() + n2; n6 > 0; --n6) {
                    stringBuffer.append(' ');
                }
            }
            return stringBuffer;
        }
        int n7 = (int)(Double.doubleToLongBits(d2) >> 52) - 1023;
        n7 = n7 * 3 / 10;
        double d3 = AstroMath.dexp(n7);
        while (d2 < d3) {
            d3 = AstroMath.dexp(--n7);
        }
        while (d2 >= 10.0 * d3) {
            d3 = AstroMath.dexp(++n7);
        }
        d2 /= d3;
        if ((n3 & 0x40) == 0 && n > 0 && (d2 += 5.0 / AstroMath.dexp(n)) >= 10.0) {
            d3 /= 10.0;
            ++n7;
        }
        this.editDecimal(stringBuffer, d2, bl2 ? 1 : 2, n - 1, n4 & 0xFFFFFFDF | 0x40);
        if (bl2 && Editing.remove_zeroes(stringBuffer)) {
            if ((n3 & 0xA) == 0) {
                stringBuffer.append('.');
            } else if (stringBuffer.length() == 1 + n5 && stringBuffer.charAt(n5) == '1') {
                stringBuffer.setLength(n5);
                string = "10";
            }
        }
        stringBuffer.append(string);
        this.editInt(stringBuffer, n7, n2, 48);
        return stringBuffer;
    }

    public StringBuffer editDouble(StringBuffer stringBuffer, double d, int n) {
        return this.editDouble(stringBuffer, d, 0, 0, n);
    }

    public StringBuffer editSexa(StringBuffer stringBuffer, double d, int n, int n2, int n3) {
        int n4;
        int n5 = n3;
        int n6 = Math.abs(n2);
        boolean bl = n2 < 0;
        int n7 = n3 & 0xF;
        double d2 = d;
        if (n7 == 0) {
            n7 = 5;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            this.editDecimal(stringBuffer, d, n, n6, n3);
            return stringBuffer;
        }
        if (((n7 = sexadrive[n7]) & 0x1000) != 0) {
            n6 -= 2;
        }
        if ((n7 & 0x2000) != 0) {
            n6 -= 4;
        }
        while (n6 < 0 && (n7 & 0xF000) != 0) {
            n7 = (short)(n7 - 4096);
            n6 += 2;
            if ((n7 & 0xF000) != 0) {
                if ((n7 & 0xF) == 0) {
                    n7 = (short)(n7 & 0xFF00);
                }
                n7 = (short)(n7 & 0xFFF0);
                continue;
            }
            if ((n7 & 0xF0) == 0) {
                n7 = 0;
            }
            n7 = (short)(n7 & 0xFF00);
        }
        if ((n7 & 0xF000) == 0) {
            this.editDecimal(stringBuffer, d, n, n6, n5 & 0x70);
            int n8 = n7 >> 8;
            if (n8 > 0) {
                stringBuffer.append(sexachar[n8]);
            }
            return stringBuffer;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (d < 0.0) {
            n5 |= Integer.MIN_VALUE;
            d2 = -d2;
        }
        if ((n3 & 0x40) == 0) {
            double d3 = (n7 & 0x2000) == 0 ? 60.0 : 3600.0;
            d2 += 0.5 / (d3 *= AstroMath.dexp(n6));
        }
        long l = (long)d2;
        d2 -= (double)l;
        Editing.edN(stringBuffer, l, n, n5);
        char c = sexachar[n7 >> 8 & 0xF];
        if ((n7 & 0xF000) != 0) {
            if (c != '\u0000') {
                stringBuffer.append(c);
            }
            c = sexachar[n7 >> 4 & 0xF];
            d2 *= 60.0;
            if ((n7 & 0x2000) == 0) {
                if (n6 == 0) {
                    n6 = -1;
                }
                this.editDecimal(stringBuffer, d2, 2, n6, 96);
            } else {
                n4 = (int)d2;
                d2 -= (double)n4;
                stringBuffer.append(Character.forDigit(n4 / 10, 10));
                stringBuffer.append(Character.forDigit(n4 % 10, 10));
            }
        }
        if ((n7 & 0x2000) != 0) {
            if (c != '\u0000') {
                stringBuffer.append(c);
            }
            c = sexachar[n7 & 0xF];
            d2 *= 60.0;
            if (n6 == 0) {
                n4 = (int)d2;
                stringBuffer.append(Character.forDigit(n4 / 10, 10));
                stringBuffer.append(Character.forDigit(n4 % 10, 10));
            } else {
                this.editDecimal(stringBuffer, d2, 2, n6, 96);
            }
        }
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        if (bl) {
            for (n4 = stringBuffer.length() - 1; n4 > 1 && stringBuffer.charAt(n4) == '0'; --n4) {
            }
            if (stringBuffer.charAt(n4) != '.') {
                ++n4;
            }
            stringBuffer.setLength(n4);
        }
        return stringBuffer;
    }

    private final void edate(StringBuffer stringBuffer, int n, int n2) {
        int[] nArray = new int[4];
        Astrotime.JD2YMD(2400000.5 + (double)n, nArray);
        block8: for (int i = n2; i != 0; i <<= 4) {
            int n3 = i >> 28 & 0xF;
            switch (n3) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    if (nArray[0] < 0) {
                        stringBuffer.append('-');
                        Editing.edN(stringBuffer, -nArray[0], 3, 32);
                        continue block8;
                    }
                    Editing.edN(stringBuffer, nArray[0], 4, 32);
                    continue block8;
                }
                case 2: {
                    Editing.edN(stringBuffer, nArray[1] + 1, 2, 32);
                    continue block8;
                }
                case 3: {
                    stringBuffer.append(month_list[nArray[1]]);
                    continue block8;
                }
                case 4: {
                    Editing.edN(stringBuffer, nArray[2], 2, 32);
                    continue block8;
                }
                case 5: {
                    Editing.edN(stringBuffer, nArray[3] + 1, 3, 32);
                    continue block8;
                }
                default: {
                    stringBuffer.append(datesep[n3 - 10]);
                }
            }
        }
    }

    public StringBuffer editDate(StringBuffer stringBuffer, int n) {
        this.edate(stringBuffer, n, datedrive[8]);
        return stringBuffer;
    }

    public StringBuffer editDate(StringBuffer stringBuffer, int n, int n2) {
        if ((n2 & 0x80) == 0) {
            n2 = 136;
        }
        this.edate(stringBuffer, n, datedrive[n2 & 0xF]);
        return stringBuffer;
    }

    public StringBuffer editDate(StringBuffer stringBuffer, double d, int n, int n2) {
        if (Double.isNaN(d)) {
            if (n < 2) {
                return this.editNaN(stringBuffer, n < 0 ? 0 : 11);
            }
            return this.editSexa(stringBuffer, d, 13, n - 2, 0);
        }
        if ((n2 & 0x80) == 0) {
            n2 = 136;
        }
        int n3 = (int)d;
        this.edate(stringBuffer, n3, datedrive[n2 & 0xF]);
        if (d < 0.0) {
            --n3;
        }
        double d2 = (d - (double)n3) * 86400.0;
        if (n <= 0 && (n >= -1 || d2 == 0.0)) {
            return stringBuffer;
        }
        stringBuffer.append('T');
        n3 = n - 2;
        if (n < 0) {
            n3 -= 4;
        }
        this.editSexa(stringBuffer, d2 / 3600.0, 2, n3, n2 & 0x40 | 0x20 | 5);
        return stringBuffer;
    }

    public StringBuffer editComplex(StringBuffer stringBuffer, double d, String string) {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        int[] nArray = new int[4];
        byte[] byArray = new byte[6];
        byte[] byArray2 = new byte[6];
        char[] cArray = string.toCharArray();
        int n5 = 0;
        int n6 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        double d2 = d;
        double d3 = 1.0E-11;
        int n7 = 2;
        if (Double.isNaN(d2)) {
            return this.editSexa(stringBuffer, d2, string.length(), -1, 0);
        }
        byArray[5] = 0;
        byArray[4] = 0;
        byArray[3] = 0;
        byArray[2] = 0;
        byArray[1] = 0;
        byArray[0] = 0;
        byArray2[5] = 0;
        byArray2[4] = 0;
        byArray2[3] = 0;
        byArray2[2] = 0;
        byArray2[1] = 0;
        byArray2[0] = 0;
        d2 = d2 > 0.0 ? (d2 += 0.49 * d3) : (d2 -= 0.49 * d3);
        if (cArray[0] == '\"') {
            n5 = 1;
            --n6;
        }
        int n8 = 0;
        int n9 = n5;
        while (n9 < n6) {
            if ((n4 = "YMDhmsymDdMS".indexOf(c = cArray[n9++])) < 0) continue;
            if (byArray[n4 %= 6] != 0) {
                n3 = 5 - n4;
                if (n4 > 0 && n3 > 0 && byArray[n3] == 0) {
                    byArray[n3] = byArray[n4];
                    n2 = 0;
                    while (byArray2[n2] != n4) {
                        ++n2;
                    }
                    byArray2[n2] = (byte)n3;
                    n4 = n3;
                }
            }
            byArray2[n8++] = (byte)n4;
            n = 1;
            while (n9 < n6 && cArray[n9] == c) {
                ++n;
                ++n9;
            }
            if (byArray[n4] == 0) {
                byArray[n4] = (byte)n;
            }
            if (n8 < 6) continue;
        }
        if (byArray[1] != 0 && byArray[0] == 0 && byArray[4] == 0) {
            byArray[4] = byArray[1];
            byArray[1] = 0;
            n2 = 0;
            while (byArray2[n2] != 1) {
                ++n2;
            }
            byArray2[n2] = 4;
            bl2 = true;
        } else if (byArray[1] == 0 && byArray[0] != 0 && byArray[4] != 0 && byArray[5] == 0) {
            byArray[1] = byArray[4];
            byArray[4] = 0;
            n2 = 0;
            while (byArray2[n2] != 4) {
                ++n2;
            }
            byArray2[n2] = 1;
            bl2 = true;
        }
        if (byArray[2] != 0 && byArray[3] == 0 && byArray[0] == 0 && byArray[1] == 0) {
            byArray[3] = byArray[2];
            byArray[2] = 0;
            n2 = 0;
            while (byArray2[n2] != 2) {
                ++n2;
            }
            byArray2[n2] = 3;
            bl2 = true;
        } else if (byArray[3] != 0 && byArray[0] != 0 && byArray[2] == 0) {
            byArray[2] = byArray[3];
            byArray[3] = 0;
            n2 = 0;
            while (byArray2[n2] != 3) {
                ++n2;
            }
            byArray2[n2] = 2;
            bl2 = true;
        }
        if (bl2) {
            // empty if block
        }
        if (byArray[0] != 0) {
            Astrotime.JD2YMD(2400000.5 + d2, nArray);
            d2 -= Math.floor(d2);
        } else {
            if (d2 < 0.0) {
                bl = true;
                d2 = -d2;
            }
            if (byArray[2] > 0) {
                nArray[3] = (int)d2;
                d2 -= (double)nArray[3];
            } else {
                n7 = 3;
            }
        }
        char c2 = '\u0000';
        c = '\u0000';
        n4 = 0;
        n8 = 0;
        n9 = n5;
        while (n9 < n6) {
            c2 = c;
            c = cArray[n9];
            if (c == 'f') break;
            ++n9;
            n4 = "YMDhmsymDdMS".indexOf(c);
            if (n4 < 0) {
                stringBuffer.append(c);
                continue;
            }
            n3 = n4 % 6;
            if (n8 < 6) {
                n3 = byArray2[n8++];
                n = byArray[n3];
            } else {
                n = 0;
            }
            if (n == 0) {
                n = 1;
                while (n9 < n6 && cArray[n9] == c) {
                    ++n;
                    ++n9;
                }
            }
            n9 += n - 1;
            if (bl) {
                stringBuffer.append('-');
                bl = false;
                --n;
            }
            while (n7 < n3) {
                d2 *= fac6[n7];
                d3 *= fac6[n7];
                ++n7;
            }
            switch (n3) {
                case 0: {
                    n2 = nArray[0];
                    if (byArray[0] == 2) {
                        n2 %= 100;
                    }
                    Editing.edN(stringBuffer, n2, n, 32);
                    break;
                }
                case 1: {
                    if (byArray[1] > 2) {
                        stringBuffer.append(month_list[nArray[1]]);
                        break;
                    }
                    Editing.edN(stringBuffer, nArray[1] + 1, 2, 32);
                    break;
                }
                case 2: {
                    if (n < 2) {
                        n = 2;
                    }
                    n2 = byArray[1] == 0 ? nArray[3] : nArray[2];
                    Editing.edN(stringBuffer, n2, n, byArray[0] > 0 ? 32 : 0);
                    break;
                }
                case 3: {
                    if (n < 2) {
                        n = 2;
                    }
                    n2 = (int)d2;
                    Editing.edN(stringBuffer, n2, n, byArray[2] > 0 ? 32 : 0);
                    d2 -= (double)n2;
                    break;
                }
                case 4: {
                    if (n < 2) {
                        n = 2;
                    }
                    n2 = (int)d2;
                    Editing.edN(stringBuffer, n2, n, n2 < 60 ? 32 : 0);
                    d2 -= (double)n2;
                    break;
                }
                case 5: {
                    if (n < 2) {
                        n = 2;
                    }
                    n2 = (int)d2;
                    Editing.edN(stringBuffer, n2, n, n2 < 60 ? 32 : 0);
                    d2 -= (double)n2;
                }
            }
        }
        if (bl) {
            stringBuffer.append('-');
            bl = false;
        }
        n = 0;
        if (c == 'f') {
            while (n9 < n6 && cArray[n9] == 'f') {
                ++n;
                ++n9;
            }
        }
        if (n > 0 || d2 > d3) {
            if (n == 0 && c2 != '.') {
                stringBuffer.append('.');
            }
            int n10 = n3 = n > 0 ? n : 9;
            while (--n3 >= 0) {
                d3 *= 10.0;
                n2 = (int)(d2 *= 10.0);
                d2 -= (double)n2;
                stringBuffer.append(Character.forDigit(n2, 10));
                if (!(d2 <= d3) || n != 0) continue;
            }
        }
        while (n9 < n6) {
            stringBuffer.append(cArray[n9]);
            ++n9;
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("null_text=");
        stringBuffer.append(this.nulls[0]);
        stringBuffer.append(", inf_text=");
        stringBuffer.append(this.inf_string);
        return stringBuffer.toString();
    }
}

